<?php
namespace App\Models;

use CodeIgniter\Model;

class AdminModel extends Model
{
    protected $table=''; // Default table name
    protected $primaryKey='';           // Default primary key
    protected $allowedFields='';
    protected $registrationFields = ['id', 'shop_name', 'owner_name', 'dob', 'phone_no', 'alternative_phone_no', 'address', 'city', 'state', 'pincode', 'otp', 'otp_verify']; // Enable automatic timestamps

    protected $categoriesFields = ['id', 'categoryName']; // Enable automatic timestamps

    protected $subCategoriesFields = ['id', 'categoryName','categoryId','subCategoryName'];

    public function tables(string $tableName,String $primaryKey,array $allowedFields){
        $this->table = $tableName;
        $this->primaryKey = $primaryKey;
        $this->allowedFields = $allowedFields;
        return $this;
    }

   public function registrationTable()
   {
       return $this->tables("registration","id",$this->registrationFields);
   }
    public function categoriesTable()
    {
         return $this->tables("categories","id",$this->categoriesFields);
    }
    public function subCategoriesTable()
    {
        return $this->tables("subcategories","id",$this->subCategoriesFields);
    }
}